-- currenttime()    = TimeStamp Without Time Zone
-- current_timestap = TimeStamp With Time Zone
-- Info: "WITHOUT TIME ZONE" nicht mehr nötig - TIMESTAMP wurde mit Postgre 7.3 dem SQL-Standard angepasst und ist jetzt standardmäßig ohne TIMEZONE
CREATE OR REPLACE FUNCTION currenttime() 
RETURNS timestamp AS $$
  SELECT date_trunc(
      'second', 
      statement_timestamp()::timestamp
  )
$$ LANGUAGE sql;


-- wegen Index-Nutzung: https://stackoverflow.com/questions/68497605/postgresql-not-using-index-for-queries-using-current-user
CREATE OR REPLACE FUNCTION currentuser() 
RETURNS varchar AS $$
   SELECT current_user::varchar
$$ LANGUAGE sql STABLE;


CREATE OR REPLACE FUNCTION tsystem.array_unique( _array anyarray )
RETURNS anyarray AS $$
    SELECT array( SELECT DISTINCT unnest( _array ) );
$$ LANGUAGE sql IMMUTABLE;

-- alternative zur standard array syntax array[1,2,3]::int[] 
-- da delphi/PgDac keine arrays an queries binden kann
CREATE OR REPLACE FUNCTION tsystem.array__create(
     VARIADIC _elements anyarray
  ) 
  RETURNS anyarray AS $$      
      SELECT _elements
  $$ LANGUAGE sql IMMUTABLE;

CREATE OR REPLACE FUNCTION tsystem.array__create__from__variadic(
  VARIADIC _elements varchar[]
  )
  RETURNS varchar[]
  AS $$
     SELECT _elements;
  $$ LANGUAGE sql IMMUTABLE;
  
CREATE OR REPLACE FUNCTION tsystem.array__create__from__variadic(
  VARIADIC _elements integer[]
  )
  RETURNS integer[]
  AS $$
     SELECT _elements;
  $$ LANGUAGE sql IMMUTABLE;  

CREATE OR REPLACE FUNCTION tsystem.function__drop_by_regex( 
      _functionname_regex varchar, 
      _namespace_regex varchar = '.*', 
      _cascade bool = false, 
      _commit bool = false 
  ) RETURNS void AS $$
  DECLARE
      _function_data record;
      _query text;
  BEGIN
  
      -- _functionname_regex and _namespace_regex are put into a ^<exp>$ regex
      -- which results in exact matches. for unanchored matches you need to
      -- specify an expression like ".*abk.*" which drops every function with
      -- abk in its name.

      IF ( NOT _commit ) THEN
          RAISE NOTICE 'dry run:';
      END IF;

      FOR _function_data IN
      
        SELECT proname, nspname, 
               pg_get_function_identity_arguments(p.oid) params
          FROM pg_proc p 
          JOIN pg_namespace n ON p.pronamespace = n.oid 
         WHERE proname ~* ('^' || _functionname_regex || '$')
           AND nspname ~* ('^' || _namespace_regex || '$')
      LOOP
      
          _query := format( '  DROP FUNCTION %I.%I(%s)', _function_data.nspname, _function_data.proname, _function_data.params );
          
          IF ( _cascade ) THEN
              _query := _query || ' CASCADE;';
          END IF;
        
          RAISE NOTICE '%', _query;
          
          IF ( _commit ) THEN
              EXECUTE _query;  
          END IF;
      
      END LOOP;
      
  END $$ language plpgsql;

-- Gibt den Paramater des Connection Strings korrekt maskiert und umschlossen in einfachen Anführungsstrichen zurück.
-- Für die Maskierung werden C-Style Escapes (z.B. "'" -> "\'") benutzt.
-- Siehe https://www.postgresql.org/docs/current/libpq-connect.html#id-1.7.3.8.3.5.
-- Beispiel:
-- _connstr := concat(   'host=',      quote_literal__connstr_param( _host ),
--                       ' port=',     quote_literal__connstr_param( _port ),
--                       ' dbname=',   quote_literal__connstr_param( _dbname ),
--                       ' user=',     quote_literal__connstr_param( _user ),
--                       ' password=', quote_literal__connstr_param( _password ),
--                    );
CREATE OR REPLACE FUNCTION tsystem.quote_literal__connstr_param(
    IN _text varchar
  ) RETURNS varchar AS $$
  DECLARE
    _result varchar;
  BEGIN
    _result := REPLACE( REPLACE( _text, E'\\', E'\\\\' ), E'\'', E'\\\'');
    _result := concat(  '''',
                        _result,
                        ''''
                      );
    RETURN _result;
  END; $$ LANGUAGE plpgsql;
